/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAttachment;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AttachmentItemDataAccessor
extends IAttachment {
    public static final String ATTACHMENT_ID_TAG = "AttachmentId";
    public static final String SKIN_ID_TAG = "Skin";
    public static final String ZOOM_NUMBER_TAG = "ZoomNumber";

    @NotNull
    public static class_2960 getAttachmentIdFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        if (nbt.method_10573(ATTACHMENT_ID_TAG, 8)) {
            class_2960 attachmentId = class_2960.method_12829((String)nbt.method_10558(ATTACHMENT_ID_TAG));
            return Objects.requireNonNullElse(attachmentId, DefaultAssets.EMPTY_ATTACHMENT_ID);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    public static int getZoomNumberFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return 0;
        }
        if (nbt.method_10573(ZOOM_NUMBER_TAG, 3)) {
            return nbt.method_10550(ZOOM_NUMBER_TAG);
        }
        return 0;
    }

    public static void setZoomNumberToTag(class_2487 nbt, int zoomNumber) {
        nbt.method_10569(ZOOM_NUMBER_TAG, zoomNumber);
    }

    @Override
    @NotNull
    default public class_2960 getAttachmentId(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        return AttachmentItemDataAccessor.getAttachmentIdFromTag(nbt);
    }

    @Override
    default public void setAttachmentId(class_1799 attachmentStack, @Nullable class_2960 attachmentId) {
        class_2487 nbt = attachmentStack.method_7948();
        if (attachmentId != null) {
            nbt.method_10582(ATTACHMENT_ID_TAG, attachmentId.toString());
        }
    }

    @Override
    @Nullable
    default public class_2960 getSkinId(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        if (nbt.method_10573(SKIN_ID_TAG, 8)) {
            return class_2960.method_12829((String)nbt.method_10558(SKIN_ID_TAG));
        }
        return null;
    }

    @Override
    default public void setSkinId(class_1799 attachmentStack, @Nullable class_2960 skinId) {
        class_2487 nbt = attachmentStack.method_7948();
        if (skinId != null) {
            nbt.method_10582(SKIN_ID_TAG, skinId.toString());
        } else {
            nbt.method_10551(SKIN_ID_TAG);
        }
    }

    @Override
    default public int getZoomNumber(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        return AttachmentItemDataAccessor.getZoomNumberFromTag(nbt);
    }

    @Override
    default public void setZoomNumber(class_1799 attachmentStack, int zoomNumber) {
        class_2487 nbt = attachmentStack.method_7948();
        AttachmentItemDataAccessor.setZoomNumberToTag(nbt, zoomNumber);
    }
}

